#include "General.h"
#include "ResetMatch.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "GameObjManager.h"
#include "SmartGameObj.h"
#include "cPlayer.h"

#define GDI 1
#define NOD 0

#define GREEN "104,234,40"

void PPage(int ID, const char* rgb_colour, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s",ID, buffer);
                return;
	}
	else
	{
		Console("cmsgp %d %s %s", ID, rgb_colour, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Reset_Match()
{
	GameObject *timerthing = Find_Object_With_Script("Reset_Match_Timer");

	Commands->Send_Custom_Event(0, timerthing, 2, 1, 0.5f);

}

int Get_Team_Player_Count_Working(int Team)
{
	int Total = 0;
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive)
		{
			int ID = p->PlayerId;
			if (Get_Team(ID) == Team)
			{
				Total++;
			}
		}
	}
	return Total;
}

bool Is_Every_Player_Ready()
{
	if (Get_Team_Player_Count_Working(NOD) < 1)
	{
		return false;
	}

	if (Get_Team_Player_Count_Working(GDI) < 1)
	{
		return false;
	}

	bool Found = false;

	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				const char* PlayerName = Get_Player_Name(o);
				int Count = ReadyList.Count();
				for( int i = 0; i < Count; i++)
				{
					if (strcmp(ReadyList[i], PlayerName) == 0)
					{
						Found = true;
						break;
					}
				}
				if (Found != true)
				{
					return false;
				}
				Found = false;
			}
		}
		x = x->Next();
	}
	return true;
}


void Kill_Harvester(int Team)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Is_Vehicle(o))
			{
				int TeamType = Commands->Get_Player_Type(o);
				if (TeamType == Team)
				{
					if (Is_Harvester(o) || Is_Harvester_Preset(o))
					{
						Commands->Apply_Damage(o,99999,"Death",0);
					}					
				}
			}
		}
		x = x->Next();
	}
}

void Kill_And_Reset_All_Players()
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				cPlayer* Data = Find_Player(Get_Player_ID(o));
				Commands->Apply_Damage(o,99999,"Death",0);
				Data->Reset_Player();
				// Data->Set_Score(0);
				// Data->Set_Money(0);
				// Data->Set_Deaths(0);
				// Data->Set_Kills(0);
			}
		}
		x = x->Next();
	}
}

void Reset_Deaths_All_Players()
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				cPlayer* Data = Find_Player(Get_Player_ID(o));
				Data->Deaths = 0;
			}
		}
		x = x->Next();
	}
}

ResetMatch::ResetMatch()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

ResetMatch::~ResetMatch()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}


bool ResetMatch::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (!MatchHasStarted)
	{
		if (Message[0] == L'!')
		{
			if (wcsistr(Message,L"!ready") == Message)
			{
				ReadyList.Add(Get_Player_Name_By_ID(PlayerID));
				if (Is_Every_Player_Ready() == true)
				{
					Reset_Match();
				}
			}
		}
		else 
		{
			PPage(PlayerID, GREEN, "You can't move and the match won't start until every player has typed !ready");
			PPage(PlayerID, GREEN, "or untill two minutes have expired.");
		}
	}
	return true;
}

void ResetMatch::OnObjectCreate(void *data,GameObject *obj)
{
	if ((Commands->Is_A_Star(obj)) && !MatchHasStarted)
	{
		Commands->Control_Enable(obj, false);
	}
}

void ResetMatch::OnLoadLevel()
{
	MatchHasStarted = false;
	ReadyList.Delete_All();

	GameObject* obj = Commands->Create_Object("Invisible_Object", Vector3(0.0f,0.0f,0.0f));
	Attach_Script_Once(obj,"Reset_Match_Timer","");
}




void Reset_Match_Timer::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this,(float)30.0f, 1);
	Commands->Start_Timer(obj, this,(float)8.0f, 16);
	Commands->Start_Timer(obj, this,(float)15.0f, 16);
}


void Reset_Match_Timer::Timer_Expired(GameObject *obj, int number)
{
	if (number == 15)
	{
		if (MatchHasStarted) return;
		//Reset_Match();
		MatchHasStarted = true;
		Kill_And_Reset_All_Players();
		Kill_Harvester(NOD);
		Kill_Harvester(GDI);
		//The_Game()->Reset_Time_Remaining_Seconds();
		The_Game()->Set_Time_Remaining_Seconds(1800); // 30 minutes
		Console("time 1800"); // does the same thing as above, I don't think the above thing works correctly
		Commands->Start_Timer(obj, this,(float)4.0f, 35);
	}

	if (number == 35)
	{
		Reset_Deaths_All_Players();
	}

	else if (number == 16)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start after 120 seconds have expired after map load.");
	}

	else if (number == 1)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 90 seconds.");
		Commands->Start_Timer(obj, this,(float)30.0f, 2);
	}
	else if (number == 2)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 60 seconds.");
		Commands->Start_Timer(obj, this,(float)30.0f, 3);
	}
	else if (number == 3)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 30 seconds.");
		Commands->Start_Timer(obj, this,(float)10.0f, 4);
	}
	else if (number == 4)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 20 seconds.");
		Commands->Start_Timer(obj, this,(float)10.0f, 5);
	}
	else if (number == 5)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 10 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 6);
	}
	else if (number == 6)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 9 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 7);
	}
	else if (number == 7)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 8 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 8);
	}
	else if (number == 8)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 7 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 9);
	}
	else if (number == 9)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 6 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 10);
	}
	else if (number == 10)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 5 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 11);
	}
	else if (number == 11)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 4 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 12);
	}
	else if (number == 12)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 3 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 13);
	}
	else if (number == 13)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 2 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 14);
	}
	else if (number == 14)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 1 second.");
		Commands->Start_Timer(obj, this,(float)1.0f, 15);
	}
	else if (number == 20)
	{
		Console("msg The match will start in 10 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 21);
	}
	else if (number == 21)
	{
		Console("msg The match will start in 9 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 22);
	}
	else if (number == 22)
	{
		Console("msg The match will start in 8 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 23);
	}
	else if (number == 23)
	{
		Console("msg The match will start in 7 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 24);
	}
	else if (number == 24)
	{
		Console("msg The match will start in 6 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 25);
	}
	else if (number == 25)
	{
		Console("msg The match will start in 5 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 26);
	}
	else if (number == 26)
	{
		Console("msg The match will start in 4 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 27);
	}
	else if (number == 27)
	{
		Console("msg The match will start in 3 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 28);
	}
	else if (number == 28)
	{
		Console("msg The match will start in 2 seconds.");
		Commands->Start_Timer(obj, this,(float)1.0f, 29);
	}
	else if (number == 29)
	{
		Console("msg The match will start in 1 second.");
		MatchHasStarted = false;
		Commands->Start_Timer(obj, this,(float)1.0f, 15);
	}
}

void Reset_Match_Timer::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == 2)
	{
		Commands->Start_Timer(obj, this,(float)1.0f, 20);
	}
}
ScriptRegistrant<Reset_Match_Timer> Reset_Match_Timer_Registrant("Reset_Match_Timer","");



ResetMatch resetMatch;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &resetMatch;
}
